"""This module contains the access checks
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from functools import wraps

from django.shortcuts import render_to_response
from django.template import RequestContext

# Dictionary containing access checks for views.
# Keys: View function name.
# Values: proposer or staff
rights = {}
 
def register(access_type):
  """Function to register access type for a View function
  """

  def wrapper(func):
    """The decorator for registering access checks.
    """

    rights['%s.%s' % (func.__module__, func.__name__)] = access_type
    return func

  return wrapper

def checkAccess(func):
  """ To check the access of the user and then return the appropriate function 
  object.
 """

  @wraps(func)
  def wrapper(request, *args, **kwargs):
    """The decorator for access check.
    """

    user_kind = rights['%s.%s' % (func.__module__, func.__name__)]
    user = request.user

    template = 'projrev/error.html'
    context = {}

    if user.is_authenticated():
      if user_kind == 'reviewer':
        if user.is_staff:
          return func(request, *args, **kwargs)
        else:
          context['not_staff'] = True 
          return render_to_response(template, RequestContext(request, context)) 

      if user_kind == 'proposer':
        if not user.is_staff:
          return func(request, *args, **kwargs)
        else:
          context['not_proposer'] = True
          return render_to_response(template, RequestContext(request, context))
    else:
      context['not_authenticated'] = True
      return render_to_response(template, RequestContext(request, context))

  return wrapper