"""This module contains the access checks
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from functools import wraps

from django.shortcuts import render_to_response
from django.template import RequestContext


rights = {}
rights['getMicr'] = 'proposer'

def checkAccess(func):
  """ To check the access of the user and then return the appropriate function 
  object.
 """

  @wraps(func)
  def wrapper(request, *args, **kwargs):
    """The decorator for access check.
    """

    user_kind = rights[func.__name__]
    user = request.user

    template = 'projrev/error.html'
    context = {}

    if user.is_authenticated():
      if user_kind == 'staff':
        if user.is_staff:
          return func(request, *args, **kwargs)
        else:
          context['not_staff'] = True 
          return render_to_response(template, RequestContext(request, context)) 

      if user_kind == 'proposer':
        if not user.is_staff:
          return func(request, *args, **kwargs)
        else:
          context['not_proposer'] = True
          return render_to_response(template, RequestContext(request, context))
    else:
      context['not_authenticated'] = True
      return render_to_response(template, RequestContext(request, context))

  return wrapper