"""A Django template tag library containing forms helpers.
"""

__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from django import template

register = template.Library()


@register.inclusion_tag('projrev/templatetags/_as_review.html')
def as_review(review):
  """Returns the comment contexts for the template tag.
  """

  total_score = (review.attribute1 + review.attribute2 + review.attribute3 + 
                 review.attribute4 + review.attribute5 + review.attribute6 +
                 review.attribute7 + review.attribute8 + review.attribute9)

  return {'review': review, 'total_score': total_score}
