"""This module contains the form helpers
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from django import forms
from django.contrib.auth.models import User

from projrev.models import Project
from projrev.models import Review

class ProposalForm(forms.ModelForm):
  """Creates a form for the project.
  """

  document = forms.FileField(required=False, help_text='Select the document path from your local file system.')

  class Meta:
    # We store most of the data in Project model. So even though the
    # name and the purpose of the form is for Proposal acceptance, we
    # use Project model here.
    model = Project

    # fields in the Project that must not appear in the form, but have
    # be automatically generated.
    fields = ('line_item', 'institution', 'state', 
              'district', 'mobile_num', 'fax_num')

class ReviewForm(forms.ModelForm):
  """Creates a form for review of proposal.
  """

  project = forms.ModelChoiceField(queryset=Project.objects.all(), 
                                   widget=forms.HiddenInput(),
                                   required=False)
  reviewer = forms.ModelChoiceField(queryset=User.objects.all(), 
                                    widget=forms.HiddenInput(),
                                    required=False)

  class Meta:
    # Create a form from Review data model.
    model = Review
