"""This module contains the views for the login for the portal.
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from django.core.urlresolvers import reverse
from django.http import HttpResponseRedirect
from django.shortcuts import render_to_response
from django.template import RequestContext


def home(request):
  """Redirect to the relevant page depending on the logged in user.
  Redirects to login page if the user is not logged in.
  """

  if request.user.is_authenticated():
    if request.user.is_staff:
      return HttpResponseRedirect(reverse('app.projrev.views.proposal.review'))
    else:
      return HttpResponseRedirect(reverse('app.projrev.views.proposal.submit'))
  else:
    template = 'projrev/home.html'
    return render_to_response(template, RequestContext(request, {}))
