"""This module contains the views for the login for the portal.
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from django.contrib.auth import authenticate
from django.contrib.auth import login
from django.contrib.auth.forms import AuthenticationForm
from django.contrib.auth.models import User
from django.db import IntegrityError
from django.http import HttpResponseRedirect
from django.shortcuts import render_to_response
from django.shortcuts import get_object_or_404


def login_validate(request):
  """Validate the user and log him in.
  """

  if request.POST:
    username = request.POST['username']
    password = request.POST['password']
    user = authenticate(username=username, password=password)
    if user is not None:
      if user.is_active:
        login(request, user)
        return HttpResponseRedirect('/proposal/submit/')
      else:
        pass
        # Return a 'disabled account' error message
    else:
      # Return an 'invalid login' error message.
      pass
  else:
    context = {}
    template = 'projrev/auth/login.html'

  return render_to_response(template, context)

def create_account(request):
  """Create an account for a user.
  """

  if request.POST:
    username = request.POST['username']
    password = request.POST['password']
    confirm_pasword = request.POST['confirmpassword']
    if password == confirm_pasword:
      try:
        user = User.objects.create_user(username, username, password)
        user.save()
        context = {
            'created': True,
            'username': username,
            }
      except IntegrityError:
        context = {
            'exits': True,
            }
    else:
      context = {
          'password_err': True,
          }
  else:
    context = {}

  template = 'projrev/auth/create_account.html'

  return render_to_response(template, context)

def forgot_password(request):
  """Resend the password if forgotten.
  """

  if request.POST:
    pass
  else:
    context = {}
    template = 'projrev/auth/forgot_password.html'

  return render_to_response(template, context)

def logout_view(request):
  """Logout the user
  """
  