"""This module contains the form helpers
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]

from django import forms

from projrev.models import Project
from projrev.models import Review

class ProposalForm(forms.ModelForm):
  """Creates a form for the project.
  """

  document = forms.FileField()
  micr_code = forms.CharField(max_length=15, required=False)

  class Meta:
    # We store most of the data in Project model. So even though the
    # name and the purpose of the form is for Proposal acceptance, we
    # use Project model here.
    model = Project

    # fields in the Project that must not appear in the form, but have
    # be automatically generated.
    fields = ('micr_code', 'line_item', 'institution', 'state', 'district')

class ReviewForm(forms.ModelForm):
  """Creates a form for review of proposal.
  """

  project = forms.ModelChoiceField(queryset=Project.objects.all(), 
                                   widget=forms.HiddenInput(),
                                   required=False)

  class Meta:
    # Create a form from Review data model.
    model = Review

    exclude = ('reviewer')
