"""This module contains the views for the login for the portal.
"""


__authors__ = [
  '"Madhusudan.C.S" <madhusudancs@gmail.com>',
]


from django.core.urlresolvers import reverse
from django.http import HttpResponseRedirect


def home(request):
  """Redirect to the relevant page depending on the logged in user.
  Redirects to login page if the user is not logged in.
  """

  if request.user.is_authenticated():
    if request.user.is_staff:
      HttpResponseRedirect(reverse('app.projrev.views.proposal.review'))
    else:
      HttpResponseRedirect(reverse('app.projrev.views.proposal.submit'))
  else:
    HttpResponseRedirect(reverse('app.projrev.views.login.login_validate'))
