#!/usr/bin/python
from transp import transp
from left_prm import left_prm

def l2r(N, degN, D, degD):
    # given Num and Den polynomial matrices in left form,
    # not necessarily coprime, finds right coprime factorisation.
    N, degN = transp(N, degN)
    D, degD = transp(D, degD)
    Rnum, Rnumdeg, Rden, Rdendeg = left_prm(N, degN, D, degD)
    Rnum, Rnumdeg = transp(Rnum, Rnumdeg)
    Rden, Rdendeg = transp(Rden, Rdendeg)

    Rnum = Rnum.squeeze()
    Rden = Rden.squeeze()
    return Rnum, Rnumdeg, Rden, Rdendeg



