#!/usr/bin/python

from dscr import dscr
import scipy as sp

def myc2d(G,Ts):
    """ Produces numerator and denominator of discrete transfer 
    function in powers of z^{-1}
    G is continuous transfer function; time delays are not allowed
    Ts is the sampling time, all in consistent time units. """
    H = dscr(G,Ts)
    num1, den1 = H.num, H.den
    A = den1[::-1]
    num2 = num1[::-1]
    nonzero = sp.find(num1)
    B = num2(nonzero)
    k = len(den1) - len(num1)
    return B,A,k
