#!/usr/bin/python

import pylab as pl
from polyfuncs import polsize

def clcoef(Q, degQ):
    """Function to clear zero leading coefficient matrices
    of a Polynomial Matrix"""
    rQ, cQ = polsize(Q, degQ)
    
    if pl.allclose(Q, pl.zeros_like(Q)):
        P = pl.zeros((rQ,cQ))
        degP = 0
    else:
        P, degP = Q, degQ
        rP, cP = rQ, cQ
        j = degP
        while j>=0:
            if pl.norm(P[:, -cP:], pl.inf) < 1e-8 *pl.norm(P, pl.inf):
                P = P[:, :j*cP]
                degP = degP-1
            else:
                j=0
            j -= 1
    return P, degP

if __name__== "__main__":
    s = """P = pl.array([[1, 2, 3, 4, 0, 0, 0, 0],
           [9, 10, 11, 12, 0, 0, 0, 0],
           [5, 6, 7, 8, 0, 0, 0, 0]])"""
    t = """degP = 3"""
    print s, t
    exec(s)
    exec(t)
    
    print clcoef(P, degP)
