#!/usr/bin/env python
# 11.15
# GMVC PID tuning of example given by Miller et al.

import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import pylab as pl
from ch_pol import ch_pol
from gmvc_pid import gmvc_pid 

# Model
A = pl.array([1, -1.95, 0.935])
B = -0.015 
k = 1
Ts = 1

# Transient specifications
N = 15
epsilon = 0.1
T = ch_pol(N, epsilon)[:1]

# Controller Design
Kc, tau_i, tau_d, L = gmvc_pid(A, B, k, T, Ts)

# L1 = filtval(L,1);
# zk = zpowk(k);
