#!/usr/bin/env python
# 12.1
# Camacho and Bordon's GPC example; model formation
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import pylab as pl
from xdync import xdync
from polyfuncs import polmul

A, dA = pl.array([1, -0.8]), 1
B, dB = pl.array([0.4, 0.6]), 1
N=3
k=1
D, dD = pl.array([1, -1]), 1
AD, dAD = pl.convolve(A,D), dA+1
Nu = N+k
zj, dzj = 1, 0
G = pl.zeros((Nu, 1))
H1 = pl.zeros((Nu, k-1+dB))
H2 = pl.zeros((Nu, dA+1))

for j in range(Nu):
    zj = pl.convolve(zj, [0,1])
    dzj = dzj + 1
    Fj, dFj, Ej, dEj = xdync(zj, dzj, AD, dAD, 1, 0)[:4]
    Gj, dGj = polmul(B, dB, Ej, dEj)
    m, n = G.shape
    G = pl.column_stack((G, pl.zeros((m, dGj-n))))
    G[j, :dGj] = Gj[dGj-1::-1]
    H1[j,:k-1+dB] = Gj[dGj:dGj+k-1+dB]
    H2[j,0:dA+1] = Fj

print "G"
print G
print "H1"
print H1
print "H2"
print H2
