#!/usr/bin/python
# 13.6
# Viscosity control problem of MacGregor

import scipy as sp
from pylab import plot, show
from lqg import lqg
from cl import cl

A, dA = sp.array([1, -0.44]), 1
B, dB = sp.array([0.51, 1.21]), 1
F, dF = sp.array([1, -1]), 1
C, dC = sp.array([1, -0.44]),1
k = 1
V, W = 1, 1
dV, dW = 0, 0
u_lqg = []
y_lqg =[]
uy_lqg = []
int1 = 1

for rho in sp.arange(0.001, 3, 0.1):
    R1,dR1,Sc,dSc = lqg(A,dA,B,dB,C,dC,k,rho,V,dV,W,dW,F,dF)
    Nu,dNu,Du,dDu,Ny,dNy,Dy,dDy,yvar,uvar = cl(A,dA,B,dB,C,dC,k,Sc,dSc,R1,dR1,int1)
    uvar = sp.atleast_1d(uvar.squeeze())
    yvar = sp.atleast_1d(yvar.squeeze())
    u_lqg = sp.concatenate((u_lqg, uvar))
    y_lqg = sp.concatenate((y_lqg, yvar))
    if sp.size(uy_lqg) == 0:
        uy_lqg = sp.array([rho, uvar[0], yvar[0]])
    else:
        uy_lqg = sp.vstack((uy_lqg, sp.array([rho, uvar[0], yvar[0]])))

plot(u_lqg, y_lqg)
show()

