#!/usr/bin/python
# 9.10  

import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from zpowk import zpowk
from desired import desired
from pp_im import pp_im

# Control of IBM lotus domino server
# Transfer function

B = 0.47
A = sp.array([1, -0.43])
k = 1
zk, dzk = zpowk(k)
 
# Transient specifications
rise = 10
epsilon = 0.01
Ts = 1
phi = desired(Ts,rise,epsilon)

# Controller design
Delta = sp.array([1, -1])  # internal model of step used
Rc, Sc, Tc, gamm = pp_im(B, A, k, phi, Delta)

# Simulation parameters for stb_disc.cos
st = 1 # desired change
t_init = 0 # simulation start time
t_final = 40 # simulation end time
C = 0
D = 1 
N_var = 0
