#!/usr/bin/python
# 5.2

import scipy as sp
from pylab import *

omega = linspace(0, pi, 100)
ejw = exp(-1j*omega)
G1 = 1.5*(1-0.4*ejw)
mag1 = abs(G1)
angle1 = angle(G1)*180/pi
G2 = -0.6*(1-2.5*ejw)
mag2 = abs(G2)
angle2 = angle(G2)*180/pi

subplot(2,1,1)
plot(omega,mag1,omega,mag2,'--')
ylabel('Magnitude')

subplot(2,1,2) 
plot(omega,angle1,omega,angle2,'--')
xlabel('w (rad/s)')
ylabel('Phase')

show()
#axis tight, label('',18,'w (rad/s)','Phase',18)
