import scipy as sp
from scipy import linalg
from scipy import signal

def dscr(H,Ts):
    """ Given a Continuous system and a Time step, returns a discretized system."""
    (n,m) = H.B.shape
    S = sp.zeros((n+m,n+m))
    S[:n,:n] = H.A
    S[:n,n:] = H.B
    s = linalg.expm(S*Ts)
    f = s[:n,:n]
    g = s[:n,n:]
    Hd = signal.lti(f, g, H.C, H.D)
    return Hd
