#!/usr/bin/python 
# 9.7
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from scipy import signal
from zpowk import zpowk
from pp_basic import pp_basic
from desired import desired

Ts = 1
B = sp.array([1, -3])
A = sp.array([1, 2, -8])
k = 1

# Since k=1, tf is of the form z^-1
zk, dzk = zpowk(k) 


# Transient specifications
rise = 10
epsilon = 0.1
phi = desired(Ts, rise, epsilon)

# Controller design
Rc, Sc, Tc, gamm = pp_basic(B, A, k, phi)

# Setting up simulation parameters for basic
st = 1.0 # desired change in h, in m.
t_init = 0  # simulation start time
t_final = 1000 # simulation end time

# Setting up simulation parameters for c_ss_cl
N_var = 0
N = 1
C = 0 
D = 1
  
