#!/usr/bin/env python
# 12.2

import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import pylab as pl
from xdync import xdync
from polyfuncs import polmul, poladd

def gpc_col(A, dA, B, dB, C, dC, N, k, rho):
    D, dD = pl.array([1, -1]), 1
    AD, dAD = pl.convolve(A, D), dA+1
    Nu = N+1
    zj, dzj = 1, 0
    G = pl.zeros((Nu, 1))
    H1 = pl.zeros((Nu, 2*k+N-2+dB))
    H2 = pl.zeros((Nu, k+N+dA))

    for j in range(Nu):
        zj = pl.convolve(zj, [0,1])
        dzj = dzj + 1
        Fj, dFj, Ej, dEj = xdync(zj, dzj, AD, dAD, C, dC)[:4]
        Nj, dNj, Mj, dMj = xdync(zj, dzj, C, dC, 1, 0)[:4]
        Gj, dGj = polmul(Mj, dMj, Ej, dEj)
        Gj, dGj = polmul(Gj, dGj, B, dB)
        Pj, dPj = polmul(Mj, dMj, Fj, dFj)
        Pj, dPj = poladd(Nj, dNj, Pj, dPj)

        m, n = G.shape
        G = pl.column_stack((G, pl.zeros((m, j+1-n))))
        G[j, :j+1] = Gj[j::-1]
        H1[j,:dGj-j] = Gj[j+1:dGj+1]
        H2[j,:dPj+1] = Pj

    K = pl.dot(pl.inv(pl.dot(G.T, G) + rho*pl.eye(Nu,Nu)), G.T)
    KH1 = pl.dot(K, H1)
    KH2 = pl.dot(K, H2)
    R1 = pl.concatenate(([1], KH1[0,:]))
    dR1 = len(R1)-1
    Sc = KH2[0,:]
    dSc = len(Sc)-1;
    Tc = K[0,:]
    dTc = len(Tc)-1;
        
    return K, KH1, KH2, Tc, dTc, Sc, dSc, R1, dR1
