#!/usr/bin/python
# 10.2
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from zpowk import zpowk
from pp_im import pp_im
from polyfuncs import poladd

Ts = 1
B = 0.63
A = sp.array([1, -0.37])
k = 3
Bd = sp.convolve(B, [0,1])
kd = k - 1

zkd, dzkd = zpowk(kd)
mzkd, dmzkd = poladd(1, 0, -zkd, dzkd)

phi = sp.array([1, -0.5])
delta = 1

Rc, Sc, Tc, gamm = pp_im(B, A, k, phi, delta)
print "Rc =", Rc
print "Sc =", Sc
print "Tc =", Tc
print "gamm =", gamm


#// simulation parameters for stb_disc.cos 
#// y1: 0 to 1; u1: 0 to 1.2
st = 1.0 #// desired change in setpoint
t_init = 0 #// simulation start time
t_final = 20 # // simulation end time

#// simulation parameters for stb_disc_10.1.cos
N_var = 0
C = 0
D = 1
N = 1
