#!/usr/bin/python
# 10.3

import scipy as sp

def imcsplit(B, polynomial):
    """ Splits a polynomial B into good, nonminimum with 
    positive real & with negative real parts.
    All are returned in polynomial form.
    Gain is returned in Kp and delay in k."""
    k = 0
    Kp = 1
    if polynomial:
        roots = sp.roots(B)
        Kp = sum(B)/sum(sp.poly(roots))
    else:
        roots = B
    Bg, Bnmp, Bm = sp.array([1]), sp.array([1]), sp.array([1])
    for root in roots:
        if root == 0:
            k += 1
        elif abs(root)<1 and root.real>=0:
            Bg = sp.convolve(Bg, [1, -root])
        elif abs(root)>=1 and root.real>=0:
            Bnmp = sp.convolve(Bnmp, [1, -root])
        else:
            Bm = sp.convolve(Bm, [1, -root])
    return Kp, k, Bg, Bnmp, Bm
