#!/usr/bin/python
# 10.4

import scipy as sp
from imcsplit import imcsplit

def imc_stable1(B, A, k, alpha):
    """ Designs Discrete Internal Model Controller
    for transfer function z^{-k}B(z^{-1})/A(z^{-1})
    Numerator and Denominator of IMC HQ are outputs
    Controller is also given in R,S form. """
    Kp, d, Bg, Bnmp, Bm = imcsplit(B, 1)
    Bg = Kp * Bg
    Bnmpr = Bnmp[::]
    Bms = sum(Bm)
    HiN = A
    HiD = Bms * sp.convolve(Bg, Bnmpr)
    k = k+d
    return k, HiN, HiD
