#!/usr/bin/python

import pylab as pl
from rowjoin import rowjoin
from polyfuncs import polsize
from cindep import cindep
from seshft import seshft
from colsplit import colsplit
from left_prm import left_prm
from move import move
from clcoef import clcoef

def xdync(N, degN, D, degD, C, degC, gap=1.0e8):
    """ """
    C = pl.atleast_2d(C)
    F, degF = rowjoin(D, degD, N, degN)
    Frows, Fbcols = polsize(F, degF)
    B, degB, A, degA, S, sel, degT1, Fbcols = left_prm(N, degN, D, degD, 3, gap)
    Crows, Ccols = C.shape
    Srows, Scols = pl.atleast_2d(S).shape
    S = S[sel!=0,:]
    T2 = pl.array([])

    for i in range(Crows):
        Saug = seshft(S, C[i,:], 0)
        b = cindep(Saug)
        b = move(b, pl.find(sel), Srows)
        if T2.size != 0:
            T2 = pl.vstack((T2, b))
        else:
            T2 = b.copy()

    X, degX, Y, degY = colsplit(T2, degT1, Fbcols, Frows-Fbcols)
    X, degX = clcoef(X, degX)
    Y, degY = clcoef(Y, degY)

    return Y, degY, X, degX, B, degB, A, degA


if __name__== "__main__":
    N = pl.array([[0,  4, 0, 1],
               [-1, 8, 0, 3]])
    dN = 1
    D = pl.array([[0, 0,  1, 4, 0, 1],
               [0, 0, -1, 0, 0, 0]])
    dD = 2
    C = pl.array([[1, 0, 1, 1],
               [0, 2, 0, 1]])
    dC = 1

    print xdync(N,dN,D,dD,C,dC)


