#!/usr/bin/python

from polyfuncs import polsize
import scipy as sp

def transp(Q, degQ):
    """ Function to transpose a polynomial matrix. """
    rQ, cQ = polsize(Q, degQ)
    rP = cQ
    cP = rQ
    degP = degQ
    P = sp.zeros((rP, (degP+1)*cP))
    for i in range(degP+1):
        P[..., i*cP:(i+1)*cP] = Q[..., i*cQ:(i+1)*cQ].T

    return P, degP
