#!/usr/bin/python
# 11.7

# N and D polynomials in z^{-1} form; discrete case
import scipy as sp
from l2r import l2r
from scipy import signal
from covar_m import covar_m

def tfvar(N,dN,D,dD):
    N,dN,D,dD = l2r(N,dN,D,dD)
    N = N/D[0]
    D = D/D[0]
    LN, LD = len(N), len(D)
    D1 = D
    if LD<LN:
        D1 = sp.hstack((D, sp.zeros(LN-LD)))
        dD1 = dD+LN-LD
    H = signal.lti(N, D1)
    yvar = covar_m(H,1)
    return N,dN,D,dD,yvar
