#!/usr/bin/python
# Superposes two polynomial matrices. 

import pylab as pl
from polyfuncs import polsize

def rowjoin(P1, degP1, P2, degP2):
    
    rP1, cP1 = polsize(P1, degP1)
    rP2, cP2 = polsize(P2, degP2)
    if not cP1 == cP2:
        print 'rowjoin: Inconsistent numbers of columns'
        exit()

    rP = rP1 + rP2
    cP = cP1
    degP = max(degP1, degP2)

    P = pl.atleast_2d(pl.zeros((rP,(degP+1)*cP)))
    P[0:rP1,0:(degP1+1)*cP1] = P1
    P[rP1:rP,0:(degP2+1)*cP2] = P2

    return P, degP

if __name__== "__main__":
    s = """P = pl.array([[1, 2, 3, 4, 1, 2, 3, 4],
           [9, 10, 11, 12, 9, 10, 11, 12],
           [5, 6, 7, 8, 5, 6, 7, 8]])"""
    print s
    exec(s)
    print """rowjoin(P, 3, P, 3)"""
    print rowjoin(P, 3, P, 3)
