#!/usr/bin/python
# 9.8
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from polyfuncs import polmul
from polyfuncs import polsplit3
from zpowk import zpowk
from xdync import xdync

def pp_im2(B, A, k, phi, Delta, a=1):
    Delta = sp.atleast_1d(Delta)
    # Setting up and solving Aryabhatta identity
    Ag, Ab = polsplit3(A, a)
    dAb = len(Ab) - 1
    Bg, Bb = polsplit3(B, a)
    dBb = len(Bb) - 1
    
    zk, dzk = zpowk(k)
    
    N, dN = polmul(Bb, dBb, zk, dzk)
    dDelta = len(Delta)-1
    D, dD = polmul(Ab, dAb, Delta, dDelta)
    dphi = len(phi)-1
    
    S1, dS1, R1, dR1 = xdync(N, dN, D, dD, phi, dphi)[:4]

    # Determination of control law
    R1 = sp.squeeze(R1)
    S1 = sp.squeeze(S1)
    Rc = sp.convolve(Bg, sp.convolve(R1, Delta))
    Sc = sp.convolve(Ag, S1)
    Tc = Ag
    gamm = phi.sum()/Bb.sum()
    # Total characteristic polynomial
    phit = sp.convolve(phi, sp.convolve(Ag, Bg)
    return Rc, Sc, Tc, gamm, phit
