#!/usr/bin/python
# 9.8
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from polyfuncs import polmul
from polyfuncs import polsplit2
from zpowk import zpowk
from xdync import xdync

def pp_basic(B, A, k, phi):
    # Setting up and solving Aryabhatta identity
    Ag, Ab = polsplit2(A)
    dAb = len(Ab) - 1
    Bg, Bb = polsplit2(B)
    dBb = len(Bb) - 1
    
    zk, dzk = zpowk(k)
    
    N, dN = polmul(Bb, dBb, zk, dzk)
    dphi = len(phi)-1
    
    S1, dS1, R1, dR1 = xdync(N, dN, Ab, dAb, phi, dphi)[:4]

    # Determination of control law
    R1 = sp.squeeze(R1)
    S1 = sp.squeeze(S1)
    Rc = sp.convolve(Bg, R1)
    Sc = sp.convolve(Ag, S1)
    Tc = Ag
    gamm = phi.sum()/Bb.sum()
    return Rc, Sc, Tc, gamm

if __name__ == "__main__":
    Ts = 1
    B = 0.63
    A = sp.array([1, -0.37])
    k = 1
    if k<=0:
        k = 1

    zk, dzk = zpowk(k)

    phi = sp.array([1, -0.5])

    print pp_basic(B, A, k, phi)
