#!/usr/bin/python
# 11.6

from zpowk import zpowk
from polyfuncs import polmul, poladd
from tfvar import tfvar

def cl(A,dA,B,dB,C,dC,k,S,dS,R,dR,int1):
    """
    int>=1 means integrated noise and control law:
    delta u = - (S/R)y
    Evaluates the closed loop transfer function and 
    variances of input and output
    """
    
    zk, dzk = zpowk(k)
    BS, dBS = polmul(B,dB,S,dS)
    zBS, dzBS = polmul(zk,dzk,BS,dBS)
    RA, dRA = polmul(R,dR,A,dA)
    
    if int1>=1:
        RA, dRA = polmul(RA, dRA, [1, -1], 1)
    D, dD = poladd(RA, dRA, zBS, dzBS)
    D = D.squeeze()
    Ny, dNy = polmul(C,dC,R,dR)
    Nu, dNu = polmul(C,dC,S,dS)

    
    Nu, dNu, Du, dDu, uvar = tfvar(Nu, dNu, D, dD)
    Ny, dNy, Dy, dDy, yvar = tfvar(Ny, dNy, D, dD)

    return Nu, dNu, Du, dDu, Ny, dNy, Dy, dDy, yvar, uvar
