#!/usr/bin/python

import pylab as pl
from makezero import makezero

def cindep(S, gap=None):
    E = pl.finfo(float).eps

    if gap == None:
        gap = 1e8

    r, c = pl.atleast_2d(S).shape

    if r>c:
        ind = 0
    else:
        sigma = pl.svd(S)[1]
        l = len(sigma)
        if(sigma[-1]/sigma[0] < (E*max(1, c))):
            ind = 0
        else:
            if pl.any(sigma[:-1]/sigma[1:] >= gap):
                ind = 0
            else:
                ind = 1
    if ind:
        b = pl.array([])

    else:
        A, B = S[r-1,:], S[:r-1,:] 
        b = pl.lstsq(B.T, A.T)[0].T
        b = makezero(b, gap)
        b = b.squeeze()
    return pl.atleast_2d(b)

if __name__== "__main__":
    pass
