#!/usr/bin/python
# given A and B arrays, returns C = [<-A-> 0
#                                    0  <-B->] with B shifted east by N cols

import pylab as pl
from scipy import signal

def seshft(A, B, N):
    Arows, Acols = pl.atleast_2d(A).shape
    Brows, Bcols = pl.atleast_2d(B).shape

    if N>=0:
        n = Arows+Brows
        m = max(Acols, Bcols+N)
        C = pl.zeros((n, m))
        C[:Arows, :Acols] = A
        C[Arows:, N:N+Bcols] = B

    else:
        N = -N
        n = Arows+Brows
        m = max(Acols+N, Bcols)
        C = pl.zeros((n, m))
        C[:Arows, N:N+Arows] = A
        C[Arows:, :Bcols] = B

    return C

if __name__== "__main__":
    a = "A = pl.eye(3)"
    b = "B = pl.eye(10)"
    n = "N = 0"
    exec(a)
    exec(b)
    exec(n)
    print a, b, n
    C = seshft(A, B, N)
    print C
