#!/usr/bin/python
# 9.8
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from polyfuncs import polmul
from zpowk import zpowk
from xdync import xdync

def pp_pid(B, A, k, phi, Delta):
    Delta = sp.atleast_1d(Delta)
    B = sp.atleast_1d(B)
    # Setting up and solving Aryabhatta identity
    dA = len(A) - 1
    dB = len(B) - 1
    
    zk, dzk = zpowk(k)
    
    N, dN = polmul(B, dB, zk, dzk)
    dDelta = len(Delta)-1
    D, dD = polmul(A, dA, Delta, dDelta)
    dphi = len(phi)-1
    
    Sc, dSc, R, dR = xdync(N, dN, D, dD, phi, dphi)[:4]

    R = sp.squeeze(R)
    Rc = sp.convolve(R, Delta)

    return Rc, Sc

if __name__ == "__main__":
    Ts = 1
    B = 0.63
    A = sp.array([1, -0.37])
    k = 1

    zk, dzk = zpowk(k)
        
    phi = sp.array([1, -0.5])
    delta = 1
        
    print pp_pid(B, A, k, phi, delta)
