#!/usr/bin/python
# Determines the first row that is dependent on the previous rows of S. 
# Returns the coefficients of dependence 

import pylab as pl
from makezero import makezero

def indep(S, gap=1e8):
    S = pl.atleast_2d(S)
    E = pl.finfo(float).eps
    r, c = S.shape
    ind = 1
    i = 2
    while ind and i<=r:
        shortS = S[:i,:]
        sigma = pl.svd(pl.dot(shortS,shortS.T))[1]
        if(sigma[-1]/sigma[0] < (E*max(i, c))):
            ind = 0
        else:
            shsig = sigma.copy()
            shsig[:-1] = sigma[1:]
            if pl.any(sigma/shsig > gap):
                ind = 0
            else:
                ind = 1
                i += 1
    if ind:
        b = pl.atleast_2d([])

    else:
        A, B = S[i-1,:], S[:i-1,:] 
        # c = A/B, 
        # c = (B.T\A.T).T
        c = pl.lstsq(B.T, A.T)[0].T
#        c = pl.solve(B.T, A.T).T
        c = makezero(c, gap)
        c = c.squeeze()
        b = pl.hstack((-c, 1))
        b = pl.atleast_2d(b)
    return b

if __name__== "__main__":
    pass
