#!/usr/bin/env python

# function [phi,psi] = ch_pol(N,epsilon)
# Returns desired characteristic polynomial and numerator
# N = rise time in number of sample times
# epsilon = overshoot as a fraction of ss gain

import pylab as pl

def ch_pol(N,epsilon):
    omega = pl.pi/2/N
    r = epsilon**(omega/pl.pi)
    phi = pl.array([1, -2*r*pl.cos(omega), r**2])
    psi = pl.array([1-r*pl.cos(omega), r**2-r*pl.cos(omega)])
    return phi, psi
