#!/usr/bin/env python
# 11.9
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import pylab as pl
from xdync import xdync
from zpowk import zpowk
from polyfuncs import polsplit3, polmul

def mv(A, dA, B, dB, C, dC, k, int1):
    zk, dzk = zpowk(k)
    Bzk, dBzk = polmul(B, dB, zk, dzk)
    
    Bg, Bb = polsplit3(B)
    Bbr = Bb[::-1]

    RHS = pl.convolve(C, pl.convolve(Bg, Bbr))
    dRHS = len(RHS) - 1

    Sc, dSc, Rc, dRc = xdync(Bzk, dBzk, A, dA, RHS, dRHS)[:4]
    return Sc, dSc, Rc, dRc

