#!/usr/bin/python
# 7.6 
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

# Continuous time antenna model

import pylab as pl
from scipy import signal
from dscr import dscr

a = 0.1
F = pl.array([[0, 1],[0, -a]])
g = pl.array([[0],[a]])
c = pl.array([1, 0])
d = 0
Ga = signal.lti(F,g,c,d)
num,den = Ga.num, Ga.den
Ts = 0.2
G = dscr(Ga,Ts)

#lead controller
beta1 = 0.8
N = pl.array([1, -0.9802])*(1-beta1)/(1-0.9802)
Rc = pl.array([1, -beta1])

# // simulation parameters using g_s_cl2.cos
# gamm = 1; Sc = 1; Tc = 1; C = 0; D = 1;
# st = 1; st1 = 0;
# t_init = 0; t_final = 20;

# // u1: -4 to 11
# // y1: 0 to 1.4

# [Tcp1,Tcp2] = cosfil_ip(Tc,1); // Tc/1
# [Np,Rcp] = cosfil_ip(N,Rc); // N/Rc
# [Scp1,Scp2] = cosfil_ip(Sc,1); // Sc/1
# [Cp,Dp] = cosfil_ip(C,D); // C/D
