#!/usr/bin/env python
# 12.2

import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import pylab as pl
from xdync import xdync
from polyfuncs import polmul, poladd

def gpc_Nc(A, dA, B, dB, C, dC, k, N1, N2, Nu, rho):
    D, dD = pl.array([1, -1]), 1
    AD, dAD = pl.convolve(A, D), dA+1
    zj, dzj = 1, 0
    for i in range(N1+k-1):
        zj = sp.convolve(zj, [0,1])
        dzj += 1
    M = 2*k+N2-2+dB
    P = max(k+N2+dA-1, dC-1)
    G = pl.zeros((N2-N1+1, Nu+1))
    H1 = pl.zeros((N2-N1+1, M))
    H2 = pl.zeros((N2-N1+1, P+1))

    for j in range(k+N1, k+N2+1):
        zj = pl.convolve(zj, [0,1])
        dzj = dzj + 1
        Fj, dFj, Ej, dEj = xdync(zj, dzj, AD, dAD, C, dC)[:4]
        Nj, dNj, Mj, dMj = xdync(zj, dzj, C, dC, 1, 0)[:4]
        Gj, dGj = polmul(Mj, dMj, Ej, dEj)
        Gj, dGj = polmul(Gj, dGj, B, dB)
        Pj, dPj = polmul(Mj, dMj, Fj, dFj)
        Pj, dPj = poladd(Nj, dNj, Pj, dPj)
        if j-k >= Nu:
            G[j-(k+N1),:Nu+1] = Gj[range(j-k, j-k-Nu-1, -1)]
        else:
            G[j-(k+N1),:j-k+1] = Gj[j-k::-1]
        H1[j-(k+N1),:j+k-2+dB] = Gj[j-k+1:2*j+dB-1]
        dPj = max(j-1+dA, dC-1)
        H2[j-(k+N1),:dPj+1] = Pj
    K = pl.dot(pl.inv(pl.dot(G.T, G) + rho*pl.eye(Nu+1, Nu+1)), G.T)
    KH1 = pl.dot(K, H1)
    KH2 = pl.dot(K, H2)
    R1 = pl.concatenate(([1], KH1[0,:]))
    dR1 = len(R1)-1
    Sc = KH2[0,:]
    dSc = len(Sc)-1;
    Tc = K[0,:]
    dTc = len(Tc)-1;
        
    return K, KH1, KH2, Tc, dTc, Sc, dSc, R1, dR1
