#!/usr/bin/env python
# 12.2

import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import pylab as pl
from xdync import xdync
from polyfuncs import polmul

def gpc_N(A, dA, B, dB, k, N1, N2, Nu, rho):
    D, dD = pl.array([1, -1]), 1
    AD, dAD = pl.convolve(A, D), dA+1
    zj, dzj = 1, 0
    for i in range(N1+k-1):
        zj = sp.convolve(zj, [0,1])
        dzj += 1
    G = pl.zeros((N2-N1+1, Nu+1))
    H1 = pl.zeros((N2-N1+1, k-1+dB))
    H2 = pl.zeros((N2-N1+1, dA+1))

    for j in range(k+N1, k+N2+1):
        zj = pl.convolve(zj, [0,1])
        dzj = dzj + 1
        Fj, dFj, Ej, dEj = xdync(zj, dzj, AD, dAD, 1, 0)[:4]
        Gj, dGj = polmul(B, dB, Ej, dEj)
        if j-k >= Nu:
            G[j-(k+N1),:Nu+1] = Gj[range(j-k, j-k-Nu-1, -1)]
        else:
            G[j-(k+N1),:j-k+1] = Gj[j-k::-1]
        H1[j-(k+N1),:k-1+dB] = Gj[j-k+1:j+dB]
        H2[j-(k+N1),:dA+1] = Fj
    K = pl.dot(pl.inv(pl.dot(G.T, G) + rho*pl.eye(Nu+1, Nu+1)), G.T)
    KH1 = pl.dot(K, H1)
    KH2 = pl.dot(K, H2)
    R1 = pl.concatenate(([1], KH1[0,:]))
    dR1 = len(R1)-1
    Sc = KH2[0,:]
    dSc = len(Sc)-1;
    Tc = K[0,:]
    dTc = len(Tc)-1;
        
    return K,KH1,KH2,Tc,dTc,Sc,dSc,R1,dR1
