#!/usr/bin/python
# 10.7
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from scipy import signal
from imc_stable1 import imc_stable1
from zpowk import zpowk
from myc2d import myc2d

num = sp.array([-1.117, 3.1472])
den = sp.array([1, 4.6429, 5.3821])
G = signal.lti(num, den)

Ts = 0.1
B, A, k = myc2d(G, Ts)

alpha = 0.9
k, GiN, GiD = imc_stable1(B, A, k, alpha)
print "k =", k
print "GiN =", GiN
print "GiD =", GiD

zk, dzk = zpowk(k)
Bp, Ap = B, A

t0 = 0
tf = 10
st = 1
Nvar = 0
