#!/usr/bin/python
# 10.10
import os, sys
sys.path += [os.getcwdu() + os.sep + ".." + os.sep + "python"]

import scipy as sp
from scipy import signal
from imc_stable import imc_stable
from zpowk import zpowk
from myc2d import myc2d

num = sp.array([-1.117, 3.1472])
den = sp.array([1, 4.6429, 5.3821])
G = signal.lti(num, den)

Ts = 0.1
B, A, k = myc2d(G, Ts)

alpha = 0.5
print B, A, k, alpha
k, HiN, HiD, R, S = imc_stable(B, A, k, alpha)
print "k =", k
print "HiN =", HiN
print "HiD =", HiD
print "R =", R
print "S =", S

zk, dzk = zpowk(k)
Bp, Ap = B, A
