# Django settings for hgbook project.

import os, sys

DEBUG = True
TEMPLATE_DEBUG = DEBUG

ADMINS = (
    ("Bryan O'Sullivan", 'bos@serpentine.com'),
)

MANAGERS = ADMINS

ROOT = os.path.dirname(sys.modules[__name__].__file__)

DJAPIAN_DATABASE_PATH = '/home/amit/hgbook-alqua/web/hgbook'
DJAPIAN_STEMMING_LANG = 'en'


try:
    from secrets import DATABASE_ENGINE, DATABASE_NAME, DATABASE_USER, \
         DATABASE_PASSWORD, DATABASE_HOST, DATABASE_PORT, SECRET_KEY
except ImportError:
    print >> sys.stderr, 'Faking up some database configuration for you'
    DATABASE_ENGINE = 'sqlite3'
    DATABASE_NAME = os.path.join(ROOT, '.database.sqlite3')
    DATABASE_USER = ''
    DATABASE_PASSWORD = ''
    DATABASE_HOST = ''
    DATABASE_PORT = ''
    SECRET_KEY = ''

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be avilable on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'America/Los_Angeles'

# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
LANGUAGE_CODE = 'en-us'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'


#Index Directories for searching static html files
DD_SEARCH_INDEX_DIR = '../html/'



# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.load_template_source',
    'django.template.loaders.app_directories.load_template_source',
#     'django.template.loaders.eggs.load_template_source',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.middleware.doc.XViewMiddleware',
    'django.contrib.flatpages.middleware.FlatpageFallbackMiddleware'
)

ROOT_URLCONF = 'hgbook.urls'

TEMPLATE_DIRS = (
    os.path.join(ROOT, 'templates')
)

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.flatpages',
    'hgbook.comments',
)
