import os, sys
from django.conf.urls.defaults import *
import hgbook.comments.feeds as feeds
from django.contrib import admin

admin.autodiscover()

feeds = {
    'comments': feeds.Comments,
    }

urlpatterns = patterns('',
    (r'^/review/comments/', include('hgbook.comments.urls')),

    (r'^/review/feeds/(?P<url>.*)/$', 'django.contrib.syndication.views.feed',
     {'feed_dict': feeds}),          
    (r'^review/$', 'hgbook.comments.views.index'), 

    (r'^/review/search/', 'hgbook.comments.views.search'), 

    # Only uncomment this for local testing without Apache.
     (r'^/review/html/(?P<path>.*)$', 'django.views.static.serve',
     {'document_root': os.path.realpath(os.path.dirname(
        sys.modules[__name__].__file__) + '/../html/')}),
     (r'^/review/support/(?P<path>.*)$', 'django.views.static.serve',
     {'document_root': os.path.realpath(os.path.dirname(
        sys.modules[__name__].__file__) + '/../support/')}),

    # Uncomment this for admin:
    (r'^admin/(.*)', admin.site.root),
)
